/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.overstressclutch;

import com.hlysine.create_connected.CCBlocks;
import com.hlysine.create_connected.Lang;
import com.hlysine.create_connected.content.overstressclutch.OverstressClutchBlock;
import com.simibubi.create.content.kinetics.RotationPropagator;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.transmission.SplitShaftBlockEntity;
import com.simibubi.create.content.redstone.diodes.BrassDiodeBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Components;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1953;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_5250;

public class OverstressClutchBlockEntity
extends SplitShaftBlockEntity {
    public int delay;
    public ScrollValueBehaviour maxDelay;

    public OverstressClutchBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.maxDelay = new TimeDelayScrollValueBehaviour((class_2561)Components.translatable((String)"create_connected.overstress_clutch.uncouple_delay"), (SmartBlockEntity)this, (ValueBoxTransform)new CenteredSideValueBoxTransform((state, d) -> {
            class_2350.class_2351 axis = d.method_10166();
            class_2350.class_2351 bearingAxis = (class_2350.class_2351)state.method_11654((class_2769)OverstressClutchBlock.AXIS);
            return bearingAxis != axis;
        })).between(1, 72000);
        this.maxDelay.withFormatter(this::format);
        this.maxDelay.withCallback(this::onMaxDelayChanged);
        this.maxDelay.setValue(1);
        behaviours.add((BlockEntityBehaviour)this.maxDelay);
    }

    private void onMaxDelayChanged(int newMax) {
        this.delay = class_3532.method_15340((int)this.delay, (int)0, (int)newMax);
        this.sendData();
    }

    private String format(int value) {
        if (value < 60) {
            return value + "t";
        }
        if (value < 1200) {
            return value / 20 + "s";
        }
        return value / 20 / 60 + "m";
    }

    public boolean isIdle() {
        return this.delay == 0;
    }

    public void initialize() {
        this.onKineticUpdate();
        super.initialize();
    }

    public void onKineticUpdate() {
        if (this.method_11010().method_11654(OverstressClutchBlock.STATE) == OverstressClutchBlock.ClutchState.UNCOUPLED && ((Boolean)this.method_11010().method_11654((class_2769)OverstressClutchBlock.POWERED)).booleanValue()) {
            this.resetClutch();
            return;
        }
        if (IRotate.StressImpact.isEnabled() && !((Boolean)this.method_11010().method_11654((class_2769)OverstressClutchBlock.POWERED)).booleanValue() && this.isOverStressed() && this.method_11010().method_11654(OverstressClutchBlock.STATE) == OverstressClutchBlock.ClutchState.COUPLED && this.field_11863 != null) {
            this.field_11863.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657(OverstressClutchBlock.STATE, (Comparable)((Object)OverstressClutchBlock.ClutchState.UNCOUPLING)), 18);
            this.delay = this.maxDelay.getValue() - 1;
            this.sendData();
            return;
        }
        if (!this.isOverStressed() && this.method_11010().method_11654(OverstressClutchBlock.STATE) == OverstressClutchBlock.ClutchState.UNCOUPLING && this.field_11863 != null) {
            this.field_11863.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657(OverstressClutchBlock.STATE, (Comparable)((Object)OverstressClutchBlock.ClutchState.COUPLED)), 18);
        }
    }

    public void updateFromNetwork(float maxStress, float currentStress, int networkSize) {
        super.updateFromNetwork(maxStress, currentStress, networkSize);
        this.onKineticUpdate();
    }

    public float getRotationSpeedModifier(class_2350 face) {
        if (this.hasSource() && face != this.getSourceFacing() && this.method_11010().method_11654(OverstressClutchBlock.STATE) == OverstressClutchBlock.ClutchState.UNCOUPLED) {
            return 0.0f;
        }
        return 1.0f;
    }

    public boolean addToTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToTooltip(tooltip, isPlayerSneaking);
        if (this.method_11010().method_11654(OverstressClutchBlock.STATE) == OverstressClutchBlock.ClutchState.UNCOUPLED) {
            Lang.translate("gui.overstress_clutch.uncoupled", new Object[0]).style(class_124.field_1065).forGoggles(tooltip);
            class_5250 hint = Lang.translateDirect("gui.overstress_clutch.uncoupled_explanation", new Object[0]);
            List cutString = TooltipHelper.cutTextComponent((class_2561)hint, (TooltipHelper.Palette)TooltipHelper.Palette.GRAY_AND_WHITE);
            for (class_2561 component : cutString) {
                Lang.builder().add(component.method_27661()).forGoggles(tooltip);
            }
            added = true;
        }
        return added;
    }

    public void resetClutch() {
        if (this.method_11010().method_11654(OverstressClutchBlock.STATE) == OverstressClutchBlock.ClutchState.UNCOUPLED && !this.isOverStressed()) {
            assert (this.field_11863 != null);
            this.field_11863.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657(OverstressClutchBlock.STATE, (Comparable)((Object)OverstressClutchBlock.ClutchState.COUPLED)), 3);
            RotationPropagator.handleRemoved((class_1937)this.field_11863, (class_2338)this.method_11016(), (KineticBlockEntity)this);
            RotationPropagator.handleAdded((class_1937)this.field_11863, (class_2338)this.method_11016(), (KineticBlockEntity)this);
        }
    }

    public void tick() {
        super.tick();
        if (this.method_11010().method_11654(OverstressClutchBlock.STATE) == OverstressClutchBlock.ClutchState.UNCOUPLING && this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_39280(this.method_11016(), (class_2248)CCBlocks.OVERSTRESS_CLUTCH.get(), 0, class_1953.field_9315);
        }
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        this.delay = compound.method_10550("Delay");
        super.read(compound, clientPacket);
    }

    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10569("Delay", this.delay);
        super.write(compound, clientPacket);
    }

    public static class TimeDelayScrollValueBehaviour
    extends ScrollValueBehaviour {
        public TimeDelayScrollValueBehaviour(class_2561 label, SmartBlockEntity be, ValueBoxTransform slot) {
            super(label, be, slot);
        }

        public ValueSettingsBoard createBoard(class_1657 player, class_3965 hitResult) {
            return new ValueSettingsBoard(this.label, 60, 10, com.simibubi.create.foundation.utility.Lang.translatedOptions((String)"generic.unit", (String[])new String[]{"ticks", "seconds", "minutes"}), new ValueSettingsFormatter(this::formatSettings));
        }

        public void onShortInteract(class_1657 player, class_1268 hand, class_2350 side) {
            class_2680 blockState = this.blockEntity.method_11010();
            class_2248 class_22482 = blockState.method_26204();
            if (class_22482 instanceof BrassDiodeBlock) {
                BrassDiodeBlock bdb = (BrassDiodeBlock)class_22482;
                bdb.toggle(this.getWorld(), this.getPos(), blockState, player, hand);
            }
        }

        public void setValueSettings(class_1657 player, ValueSettingsBehaviour.ValueSettings valueSetting, boolean ctrlHeld) {
            int multiplier;
            int value = valueSetting.value();
            switch (valueSetting.row()) {
                case 0: {
                    int n = 1;
                    break;
                }
                case 1: {
                    int n = 20;
                    break;
                }
                default: {
                    int n = multiplier = 1200;
                }
            }
            if (!valueSetting.equals((Object)this.getValueSettings())) {
                this.playFeedbackSound((BlockEntityBehaviour)this);
            }
            this.setValue(Math.max(1, Math.max(1, value) * multiplier));
        }

        public ValueSettingsBehaviour.ValueSettings getValueSettings() {
            int row = 0;
            int value = this.value;
            if (value > 1200) {
                value /= 1200;
                row = 2;
            } else if (value > 60) {
                value /= 20;
                row = 1;
            }
            return new ValueSettingsBehaviour.ValueSettings(row, value);
        }

        public class_5250 formatSettings(ValueSettingsBehaviour.ValueSettings settings) {
            int value = Math.max(1, settings.value());
            return Components.literal((String)(switch (settings.row()) {
                case 0 -> value + "t";
                case 1 -> "0:" + (value < 10 ? "0" : "") + value;
                default -> value + ":00";
            }));
        }

        public String getClipboardKey() {
            return "Timings";
        }
    }
}

